#include <SPI.h>
#include "Ap_29demo.h"
#include "2inch9_epd.h"
/***************************************************************************************
 * Project  :
 * Experimental Platform :Arduino UNO + 2.9inch E-Paper Display
 * Hardware Connection :Arduino UNO-> 2.9inch E-Paper
 *      D7 --> CS
 *      D13 --> CLK
 *      D11 --> MOSI
 *      D10  --> DC
 *      D9  --> RST
 *      D8  --> BUSY
 * Web Site    :www.seengreat.com
***************************************************************************************/

void setup() {
  pinMode(CS_Pin, OUTPUT);
  pinMode(RST_Pin, OUTPUT);
  pinMode(DC_Pin, OUTPUT);
  pinMode(BUSY_Pin, INPUT);
  SPI.begin();
  SPI.beginTransaction(SPISettings(2000000, MSBFIRST, SPI_MODE0));
}
//Tips//
/*
1.Flickering is normal when EPD is performing a full screen update to clear ghosting from the previous image so to ensure better clarity and legibility for the new image.
2.There will be no flicker when EPD performs a partial refresh.
3.Please make sue that EPD enters sleep mode when refresh is completed and always leave the sleep mode command. Otherwise, this may result in a reduced lifespan of EPD.
4.Please refrain from inserting EPD to the FPC socket or unplugging it when the MCU is being powered to prevent potential damage.)
5.Re-initialization is required for every full screen update.
6.When porting the program, set the BUSY pin to input mode and other pins to output mode.
*/
void loop() {
  unsigned char i;

  EPD_HW_Init();
  PIC_display(gImage_1);  
  EPD_DeepSleep();                     //EPD_DeepSleep,Sleep instruction is necessary, please do not delete!!!
  delay(2000);    
  delay(2000);                      //Delay for 2s.

	EPD_HW_Init();
	EPD_WhiteScreen_Red();
	EPD_DeepSleep();  //EPD_DeepSleep,Sleep instruction is necessary, please do not delete!!!
	delay(2000);

	EPD_HW_Init();
	EPD_WhiteScreen_Yellow();
	EPD_DeepSleep();  //EPD_DeepSleep,Sleep instruction is necessary, please do not delete!!!
	delay(2000);

  EPD_HW_Init();            
  EPD_WhiteScreen_White();  
  delay(1000);              //Delay for 2s.
  while (1);  // The program stops here
}
//////////////////////////////////END//////////////////////////////////////////////////
